// Quartus II Verilog Template
// One-bit wide, N-bit long shift register

module shift_register 
#(parameter N=256)
(
	input clk, enable,rst,
	input sr_in,
	input [2:0] count,
//	output reg [N-1:0] sr,
	output reg [N-1:0] sr_out
);

	// Declare the shift register
	reg [N-1:0] sr;

	// Shift everything over, load the incoming bit
	always @ (negedge clk)
	begin
		if (enable == 1'b1)
		begin
			sr[N-1:1] <= sr[N-2:0];
			sr[0] <= sr_in;
		end
		else
		  sr <= 'd0;		
	if (rst)
		  sr_out <= 'd0;
	else if (&count)
			sr_out <= sr;
	end

	// assign to the output
//	assign sr_out = sr;

endmodule
